define([
    'underscore',
    'jquery',
    'models/facilities-collection',
], function(_, $, Facilities) {
    'use strict';


    return Facilities.extend({
        comparator: 'name',
        isReady: new $.Deferred(),
        setWith: function (enrolledSiteCodes, facilities, ajaxFilter) {
            _.each(enrolledSiteCodes, function (facilityCode) {
                this.add(facilities.findWhere({facilityCode: facilityCode}));
            }.bind(this));

            if (_.isUndefined(ajaxFilter)) {
                // eslint-disable-next-line no-param-reassign
                ajaxFilter = function () {
                    var resolved = new $.Deferred();
                    resolved.resolve();
                    return resolved;
                };
            }

            ajaxFilter().done(function () {
                this._isReady.resolve();
            }.bind(this));
        },
    });
});
